/*
 * Decompiled with CFR 0.152.
 */
package com.dplayend.noenchantmentcaplevel.command;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.class_2561;

public class CustomIntegerArgumentType
implements ArgumentType<Integer> {
    private static final DynamicCommandExceptionType FAILED_LEVEL_EXCEPTION = new DynamicCommandExceptionType(level -> class_2561.method_54159((String)"commands.enchant.failed.banned", (Object[])new Object[]{level}));
    private static final Collection<String> EXAMPLES = Arrays.asList("0", "123", "-123");
    private final int minimum;
    private final int maximum;

    private CustomIntegerArgumentType(int minimum, int maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public static CustomIntegerArgumentType integer() {
        return CustomIntegerArgumentType.integer(Integer.MIN_VALUE);
    }

    public static CustomIntegerArgumentType integer(int min) {
        return CustomIntegerArgumentType.integer(min, Integer.MAX_VALUE);
    }

    public static CustomIntegerArgumentType integer(int min, int max) {
        return new CustomIntegerArgumentType(min, max);
    }

    public static int getInteger(CommandContext<?> context, String name) {
        return (Integer)context.getArgument(name, Integer.TYPE);
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public Integer parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        int result = reader.readInt();
        if (result < this.minimum) {
            reader.setCursor(start);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooLow().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)this.minimum);
        }
        if (result > this.maximum) {
            reader.setCursor(start);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooHigh().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)this.maximum);
        }
        if (result == 0 || result == -1) {
            throw FAILED_LEVEL_EXCEPTION.create((Object)String.valueOf(result));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomIntegerArgumentType)) {
            return false;
        }
        CustomIntegerArgumentType that = (CustomIntegerArgumentType)o;
        return this.maximum == that.maximum && this.minimum == that.minimum;
    }

    public int hashCode() {
        return 31 * this.minimum + this.maximum;
    }

    public String toString() {
        if (this.minimum == Integer.MIN_VALUE && this.maximum == Integer.MAX_VALUE) {
            return "integer()";
        }
        if (this.maximum == Integer.MAX_VALUE) {
            return "integer(" + this.minimum + ")";
        }
        return "integer(" + this.minimum + ", " + this.maximum + ")";
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

